﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.BMXNet.WinForm.Configuration;
using IndianHealthService.BMXNet.Forms;
using System.Windows.Forms;

namespace IndianHealthService.BMXNet.WinForm.Forms
{
    internal class RpmsLoginPresenter
    {

        private bool _enableConnectionManagement = false;

        public bool EnableConnectionManagement
        {
            get { return _enableConnectionManagement; }
            set { _enableConnectionManagement = value; }
        }

        private RpmsLoginView _view = null;

        public RpmsLoginView View
        {
            get { return _view; }
            set { _view = value; }
        }

        private LoginProcess _model = null;

        public LoginProcess Model
        {
            get { return _model; }
            set { _model = value; }
        }

        private IWin32Window _uiOwner = null;

        public IWin32Window UiOwner
        {
            get { return _uiOwner; }
            set { _uiOwner = value; }
        }


        public void Open()
        {
            this.UpdateConnectionSpecs();
            this.View.IsSwitchServerModeEnabled = this.Model.IsSwitchServerModeEnabled;
            this.View.ConnectionSpecSelected += new EventHandler(View_ConnectionSpecSelected);
        //    this.View.EnableUseWindowsAuthentication = this.View.ConnectionSpec == null ? false : this.View.ConnectionSpec.UseWindowsAuthentication;
            this.View.Ok += new EventHandler(View_Ok);
            this.View.Cancel += new EventHandler(View_Cancel);
            this.View.ShowView(this.UiOwner);         
        }

        void View_Cancel(object sender, EventArgs e)
        {
            this.Model.WasLoginAttempted = false;
            this.Model.Cancel=true;
            this.View.CloseView();
        }

        void View_Ok(object sender, EventArgs e)
        {
            if (this.View.ConnectionSpec == null)
            {
                MessageBox.Show("Selected a Connection.", "Login Failed");
            }
            else
            {
                if (this.View.AccessCode.Length == 0)
                {
                    MessageBox.Show("Please enter an Access Code.", "Login Failed");
                    return;
                }
                if (this.View.VerifyCode.Length == 0)
                {
                    MessageBox.Show("Please enter a Verify Code.", "Login Failed");
                    return;
                }
                this.View.ShowWait();
                if (this.Model.AttemptAccessVerifyLogin(this.View.ConnectionSpec, this.View.AccessCode, this.View.VerifyCode))
                {
                    this.View.HideWait();
                    this.View.CloseView();
                }
                else
                {
                    this.View.HideWait();
                    if (this.Model.HandleLoginAttemptedFailed())
                    {
                        if (this.Model.Cancel)
                        {
                            this.View.CloseView();
                            return;
                        }
                    }
                    else
                    {
                        if (this.Model.Settings.UserSettings.Get("Debug",false) && (this.Model.FailureException != null))
                        {
                            ExceptionMessageDialog.SafeShow("Login Failed", this.Model.FailureException);
                        }
                        else
                        {                     
                            MessageBox.Show(this.Model.FailureMessage, "Login Failed");
                        }
                    }

                    if (this.Model.LoginAttempts >= this.Model.MaxAttempts)
                    {
                        MessageBox.Show("The application will now close.", "Login Attempts Exceeded");
                        this.View.CloseView();
                    }
                    else
                    {
                        this.View.ResetAccessVerifyCodes();
                    }
                }
            }
        }

        void View_ConnectionSpecSelected(object sender, EventArgs e)
        {
            this.View.UseWindowsAuthentication= this.View.ConnectionSpec==null ? false : this.View.ConnectionSpec.UseWindowsAuthentication;
            this.View.EnableUseWindowsAuthentication = this.View.ConnectionSpec == null ? false : this.View.ConnectionSpec.UseWindowsAuthentication;
     
            if (this.View.ConnectionSpec != null)
            {
                

                if (this.View.ConnectionSpec.IsManageSpecsPlaceHolder)
                {
                    this.ManageSpecifications();
                    this.UpdateConnectionSpecs();
                    return;
                }

                //this.View.EnableUseWindowsAuthentication = this.View.ConnectionSpec.UseWindowsAuthentication;

                if (this.View.ConnectionSpec.UseWindowsAuthentication && this.Model.IsSwitchServerModeEnabled)
                {
                    if (this.Model.PrimitiveAttemptWindowsAuthLogin(this.View.ConnectionSpec))
                    {
                        this.View.HideWait();
                        this.View.CloseView();         
                    }

                }    
            }
        }

        private void ManageSpecifications()
        {
            RpmsServerConfigurationManagementDialog dialog = new RpmsServerConfigurationManagementDialog();
            dialog.Settings = this.Model.Settings;
            dialog.ShowDialog(this.View.UiOwner);
        }
   
        void UpdateConnectionSpecs()
        {
            List<RpmsConnectionSpec> specs = new List<RpmsConnectionSpec>();

            specs.AddRange(this.Model.Settings.ConnectionSpecs);
            
            if (this.EnableConnectionManagement)
            {
                RpmsConnectionSpec manageSpec = new RpmsConnectionSpec();
                manageSpec.IsManageSpecsPlaceHolder = true;
                manageSpec.Name = "< Click to edit connections... >";
                specs.Add(manageSpec);
            }

            this.View.ConnectionSpec = null;
            this.View.ConnectionSpecs = specs;
            this.View.ConnectionSpec = this.Model.Settings.DefaultConnectionSpec;
        }

    }
}
